C      *****************************************************************
C      * Subroutine InitCtoM                                           *
C      * Initializes the conversion factors for aqueous concentrations *
C      * to mass and for solid concentrations to mass.  These factors  *
C      * have units of liters such that when multiplied by units of    *
C      * mass per liter a unit of mass will result.  There is a set of *
C      * conversion factors for each soil layer.                       *
C      *                                                               *
C      * Variables:                                                    *
C      * AqCtoM    -Output- A vector, of size NLayers, of              *
C      *                    multiplication factors which convert       *
C      *                    aqueous concentrations to mass. There is   *
C      *                    one multiplication factor for each layer.  *
C      *                    Units are L.                               *
C      *                    (Common block VModel, file VModel.f)       *
C      * CatchArea -Input - A vector, of size NLayers, of the catchment*
C      *                    area for each layer.  Input from TREGRO, or*
C      *                    read into the model by the routine InParam.*
C      *                    Units are m**2.                            *
C      *                    (Common block VModel, file VModel.f)       *
C      * LperM3    -Local - The amount of liters per m**3.  Units are  *
C      *                    L/m**3.                                    *
C      * N         -Local - Layer number index.  Unitless.             *
C      * NLayers   -Input - The number of soil layers in the system.   *
C      *                    Input from TREGRO, or read into the model  *
C      *                    by the routine InParam.  Unitless.         *
C      *                    (Common block VPos, file VModel.f)         *
C      * SolidCtoM -Output- A vector, of size NLayers, of              *
C      *                    multiplication factors which convert solid *
C      *                    concentrations to mass.  There is one      *
C      *                    multiplication factor for each layer.      *
C      *                    Units are L.                               *
C      *                    (Common block VModel, file VModel.f)       *
C      * Theta     -Input - A vector, of size NLayers, of volumetric   *
C      *                    soil moisture contents for each layer.     *
C      *                    Input from TREGRO, or read into the model  *
C      *                    by the routine InParam.  Units are         *
C      *                    cm**3/cm**3.                               *
C      *                    (Common block VModel, file VModel.f)       *
C      * Thickness -Input - A vector, of size NLayers, of thicknesses  *
C      *                    of each soil layer.  Input from TREGRO, or *
C      *                    read into the model by the routine InParam.*
C      *                    Units are m.                               *
C      *                    (Common block VModel, file VModel.f)       *
C      *****************************************************************
       SUBROUTINE INITCTOM
							IMPLICIT NONE
							INCLUDE 'VMODEL.INC'
							REAL*8 LPERM3/1E3/
							INTEGER N
							
C      *--------------------------------------------------*
C      * Calculate the conversion factors for each layer. *
C      *--------------------------------------------------*
       DO 100 N = 1, NLAYERS
C         *-----------------------------------------------------*
C         * Calculate conversion factor, units of liters, that  *
C         * will convert units from concentration to mass for   *
C         * an aqueous substance.  Dimensions are:              *
C         * L = m**2 * m * cm**3/cm**3 * L/m**3                 *
C         *-----------------------------------------------------*
          AQCTOM(N) = CATCHAREA(N) * THICKNESS(N) * THETA(N) *
     >                LPERM3
	   
C         *---------------------------------------------------*
C         * Calculate conversion factor, units of liters, that*
C         * will convert units from concentration to mass     *
C         * for a solid substance.  Dimensions are:           *
C         * L = m**2 * m * L/m**3                             *
C         *---------------------------------------------------*
          SOLIDCTOM(N) = CATCHAREA(N) * THICKNESS(N) * LPERM3
  100  CONTINUE	  
 
	      RETURN 
	      END
C      *****************************************************************
C      *                    END SUBROUTINE                             *
C      *****************************************************************
